<?php
/**
 * Class that operate on table 'sparepart'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
class SparepartMySqlExtDAO extends SparepartMySqlDAO{

	
	public function loadExt($id){
		$sql = 'SELECT * , sparepartstoredetails.partquantity 
		FROM sparepart
		JOIN sparepartstoredetails
		ON sparepartstoredetails.sparepartid = sparepart.sparepartid 
		WHERE sparepart.sparepartid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}


	public function queryAllExt(){
		$sql = 'SELECT sparepart.*, sparepartstoredetails.partquantity 
		FROM sparepart
		JOIN sparepartstoredetails
		ON sparepartstoredetails.sparepartid = sparepart.sparepartid';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	
	public function queryAllExtLimited($start, $end){
		$sql = 'SELECT sparepart.*, sparepartstoredetails.partquantity 
		FROM sparepart
		JOIN sparepartstoredetails
		ON sparepartstoredetails.sparepartid = sparepart.sparepartid
		limit '.$start.', '.$end.'';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	
	public function updateConditions($sparepart){
		$sql = 'UPDATE sparepart SET userid = ?, sparepartdate = ?, conditions = ? WHERE sparepartid = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->setNumber($sparepart->userid);
		$sqlQuery->set($sparepart->sparepartdate);
		$sqlQuery->setNumber($sparepart->conditions);

		$sqlQuery->setNumber($sparepart->sparepartid);
		return $this->executeUpdate($sqlQuery);
	}
	
	
}
?>